/*----------------------------------------------------------------------------
 *      RL-ARM - CAN
 *----------------------------------------------------------------------------
 *      Name:    CAN_Cfg.h
 *      Purpose: Header for CAN Configuration Settings
 *      Rev.:    V4.05
 *----------------------------------------------------------------------------
 *      This code is part of the RealView Run-Time Library.
 *      Copyright (c) 2004-2009 KEIL - An ARM Company. All rights reserved.
 *---------------------------------------------------------------------------*/

#ifndef _CAN_CFG_H
#define _CAN_CFG_H

#include "CAN_Error.h"                /* CAN Error definition                */

/* 
// *** <<< Use Configuration Wizard in Context Menu >>> *** 
*/


/*
// <o>Master Clock Frequency (MCK) <1-160000000>
// <i> Peripheral clock frequency with which CAN controller is clocked
// <i> (same as Master clock frequency).
// <i> Default: 47923200
*/
#define MCK_FREQ               47923200


/*
// <o>Number of transmit objects for controllers <1-1024>
// <i> Determines the size of software message buffer for transmitting.
// <i> Default: 20
*/
#define CAN_No_SendObjects     20


/*
// <o>Number of receive objects for controllers <1-1024>
// <i> Determines the size of software message buffer for receiving.
// <i> Default: 20
*/
#define CAN_No_ReceiveObjects  20

/*
// *** <<< End of Configuration section             >>> *** 
*/

/* Maximum index of used CAN controller is 1
   Needed for memory allocation for CAN messages.                            */

#define CAN_CTRL_MAX_NUM        1

#endif /* _CAN_CFG_H */


/*----------------------------------------------------------------------------
 * end of file
 *---------------------------------------------------------------------------*/

