/*----------------------------------------------------------------------------
 *      U S B  -  K e r n e l
 *----------------------------------------------------------------------------
 *      Name:    USBUSER.C
 *      Purpose: USB Custom User Module
 *      Version: V1.10
 *----------------------------------------------------------------------------
 *      This file is part of the uVision/ARM development tools.
 *      This software may only be used under the terms of a valid, current,
 *      end user licence from KEIL for a compatible version of KEIL software
 *      development tools. Nothing else gives you the right to use it.
 *
 *      Copyright (c) 2005-2007 Keil Software.
 *---------------------------------------------------------------------------*/

#include <string.h>
#include <RTL.h>

#include "usb.h"
#include "usbcfg.h"
#include "usbhw.h"
#include "usbcore.h"
#include "usbuser.h"
#include "cdcuser.h"


OS_TID USB_DevTask;                         /* USB Device Task ID */
OS_TID USB_EPTask[16];                      /* USB Endpoint Task ID's */
OS_TID USB_CoreTask;                        /* USB Core Task ID */

U32*   USB_EPMbx[16];                       /* USB Endpoint Mailboxes */

/*
 *  USB Device Task
 *   Handles USB Device Events
 */
os_mbx_declare(USB_DevMbx, 5);                            /* USB device  mailbox */

__task void USB_Device (void) {
  U16 evt;
  T_USB_EP_EVENT *pEpEvent;

  os_mbx_init (USB_DevMbx, sizeof(USB_DevMbx));           /* initialize the mailbox */

  for (;;) {

    os_mbx_wait (USB_DevMbx, (void **)&pEpEvent, 0xFFFF); /* Wait for an Event */
    evt = pEpEvent->wEvent;                               /* Get Event Flags */


#if USB_POWER_EVENT
    if (evt & USB_EVT_POWER_ON) {
    }
    if (evt & USB_EVT_POWER_OFF) {
    }
#endif

#if USB_RESET_EVENT
    if (evt & USB_EVT_RESET) {
      USB_ResetCore();
    }
#endif

#if USB_WAKEUP_EVENT
    if (evt & USB_EVT_WAKEUP) {
    }
#endif

#if USB_SUSPEND_EVENT
    if (evt & USB_EVT_SUSPEND) {
    }
#endif

#if USB_RESUME_EVENT
    if (evt & USB_EVT_RESUME) {
    }
#endif

#if USB_SOF_EVENT
    if (evt & USB_EVT_SOF) {
    }
#endif

#if USB_ERROR_EVENT
    if (evt & USB_EVT_ERROR) {
    }
#endif

    _free_box (USB_MsgPool, pEpEvent);		              /* free memory allocated for message */
  }
}


/*
 *  USB Endpoint 1 Task
 *   Handles USB Endpoint 1 Events
 */

#if (USB_EP_EVENT & (1 << 1))
os_mbx_declare(USB_EP1Mbx, 5);                            /* EndPoint 1 mailbox */

__task void USB_EndPoint1 (void) {
  T_USB_EP_EVENT *pEpEvent;
  U16 evt;

  os_mbx_init (USB_EP1Mbx, sizeof(USB_EP1Mbx));           /* initialize the mailbox */
  USB_EPMbx[1] = USB_EP1Mbx;                              /* store Mbx in array */

  for (;;) {
    os_mbx_wait (USB_EP1Mbx, (void **)&pEpEvent, 0xFFFF); /* Wait for an Event */
    evt = pEpEvent->wEvent;                               /* Get Event Flags */

    switch (evt) {
      case USB_EVT_OUT:
        ;
        break;
      case USB_EVT_IN:
        CDC_BulkIn ();                                   /* data expected from Device */
        break;
    } // end switch

    _free_box (USB_MsgPool, pEpEvent);		              /* free memory allocated for message */
  }
}
#endif


/*
 *  USB Endpoint 2 Task
 *   Handles USB Endpoint 2 Events
 */

#if (USB_EP_EVENT & (1 << 2))
os_mbx_declare(USB_EP2Mbx, 5);                            /* EndPoint 2 mailbox */

__task void USB_EndPoint2 (void) {
  T_USB_EP_EVENT *pEpEvent;
  U16 evt;
  int numBytes;

  USB_EPMbx[2] = USB_EP2Mbx;                              /* store Mbx in array */
  os_mbx_init (USB_EP2Mbx, sizeof(USB_EP2Mbx));           /* initialize the mailbox */

  for (;;) {
    os_mbx_wait (USB_EP2Mbx, (void **)&pEpEvent, 0xFFFF); /* Wait for an Event */
    evt = pEpEvent->wEvent;                               /* Get Event Flags */

    switch (evt) {
      case USB_EVT_OUT:
        numBytes = pEpEvent->bCnt;
        // store data in a buffer to transmit it over serial interface
        CDC_WrOutBuf ((char *)pEpEvent->bData, &numBytes);
//        CDC_BulkOut ();                                   /* data received from Host */
        break;
      case USB_EVT_IN:
        ;
        break;
    } // end switch

  _free_box (USB_MsgPool, pEpEvent);		              /* free memory allocated for message */
  }
}
#endif


/*
 *  USB Endpoint 3 Task
 *   Handles USB Endpoint 3 Events
 */

#if (USB_EP_EVENT & (1 << 3))
os_mbx_declare(USB_EP3Mbx, 5);                            /* EndPoint 2 mailbox */

__task void USB_EndPoint3 (void) {
  T_USB_EP_EVENT *pEpEvent;
         U16 evt;
         U32 temp;
  static U32 serialState;

  USB_EPMbx[3] = USB_EP3Mbx;                              /* store Mbx in array */
  os_mbx_init (USB_EP3Mbx, sizeof(USB_EP3Mbx));           /* initialize the mailbox */

  for (;;) {
    os_mbx_wait (USB_EP3Mbx, (void **)&pEpEvent, 0xFFFF); /* Wait for an Event */
    evt = pEpEvent->wEvent;                               /* Get Event Flags */

    switch (evt) {
      case USB_EVT_IN:
        temp = CDC_GetSerialState();
        if (serialState != temp) {
           serialState = temp;
           CDC_NotificationIn();            /* send SERIAL_STATE notification */
        }
        break;
    } // end switch

  _free_box (USB_MsgPool, pEpEvent);		              /* free memory allocated for message */
  }
}
#endif


/*
 *  USB Endpoint 4 Task
 *   Handles USB Endpoint 4 Events
 */

#if (USB_EP_EVENT & (1 << 4))
__task void USB_EndPoint4 (void) {
}
#endif


/*
 *  USB Endpoint 5 Task
 *   Handles USB Endpoint 5 Events
 */

#if (USB_EP_EVENT & (1 << 5))
__task void USB_EndPoint5 (void) {
}
#endif


/*
 *  USB Endpoint 6 Task
 *   Handles USB Endpoint 6 Events
 */

#if (USB_EP_EVENT & (1 << 6))
__task void USB_EndPoint6 (void) {
}
#endif


/*
 *  USB Endpoint 7 Task
 *   Handles USB Endpoint 7 Events
 */

#if (USB_EP_EVENT & (1 << 7))
__task void USB_EndPoint7 (void) {
}
#endif


/*
 *  USB Endpoint 8 Task
 *   Handles USB Endpoint 8 Events
 */

#if (USB_EP_EVENT & (1 << 8))
__task void USB_EndPoint8 (void) {
}
#endif


/*
 *  USB Endpoint 9 Task
 *   Handles USB Endpoint 9 Events
 */

#if (USB_EP_EVENT & (1 << 9))
__task void USB_EndPoint9 (void) {
}
#endif


/*
 *  USB Endpoint 10 Task
 *   Handles USB Endpoint 10 Events
 */

#if (USB_EP_EVENT & (1 << 10))
__task void USB_EndPoint10 (void) {
}
#endif


/*
 *  USB Endpoint 11 Task
 *   Handles USB Endpoint 11 Events
 */

#if (USB_EP_EVENT & (1 << 11))
__task void USB_EndPoint11 (void) {
}
#endif


/*
 *  USB Endpoint 12 Task
 *   Handles USB Endpoint 12 Events
 */

#if (USB_EP_EVENT & (1 << 12))
__task void USB_EndPoint12 (void) {
}
#endif


/*
 *  USB Endpoint 13 Task
 *   Handles USB Endpoint 13 Events
 */

#if (USB_EP_EVENT & (1 << 13))
__task void USB_EndPoint13 (void) {
}
#endif


/*
 *  USB Endpoint 14 Task
 *   Handles USB Endpoint 14 Events
 */

#if (USB_EP_EVENT & (1 << 14))
__task void USB_EndPoint14 (void) {
}
#endif


/*
 *  USB Endpoint 15 Task
 *   Handles USB Endpoint 15 Events
 */

#if (USB_EP_EVENT & (1 << 15))
__task void USB_EndPoint15 (void) {
}
#endif


/*
 *  USB Core Task
 *   Handles USB Core Events
 */

os_mbx_declare(USB_CoreMbx, 5);                            /* USB device  mailbox */

__task void USB_Core (void) {
  T_USB_EP_EVENT *pEpEvent;
#if (USB_CONFIGURE_EVENT || USB_INTERFACE_EVENT || USB_FEATURE_EVENT)
  U16 evt;
#endif

  os_mbx_init (USB_CoreMbx, sizeof(USB_CoreMbx));          /* initialize the mailbox */

  for (;;) {

    os_mbx_wait (USB_CoreMbx, (void **)&pEpEvent, 0xFFFF); /* Wait for an Event */

#if (USB_CONFIGURE_EVENT || USB_INTERFACE_EVENT || USB_FEATURE_EVENT)
    evt = pEpEvent->wEvent;                                /* Get Event Flags */
#endif

#if USB_CONFIGURE_EVENT
    if (evt & USB_EVT_SET_CFG) {
    }
#endif

#if USB_INTERFACE_EVENT
    if (evt & USB_EVT_SET_IF) {
    }
#endif

#if USB_FEATURE_EVENT
    if (evt & USB_EVT_SET_FEATURE) {
    }
    if (evt & USB_EVT_CLR_FEATURE) {
    }
#endif

    _free_box (USB_MsgPool, pEpEvent);		               /* free memory allocated for message */
  }
}


/*
 *  USB Task Initialization
 */

void USB_TaskInit (void) {

  USB_DevTask = os_tsk_create(USB_Device, 3);

#if (USB_EP_EVENT & (1 << 0))
  USB_EPTask[0]  = os_tsk_create(USB_EndPoint0,  2);
#endif
#if (USB_EP_EVENT & (1 << 1))
  USB_EPTask[1]  = os_tsk_create(USB_EndPoint1,  2);
#endif
#if (USB_EP_EVENT & (1 << 2))
  USB_EPTask[2]  = os_tsk_create(USB_EndPoint2,  2);
#endif
#if (USB_EP_EVENT & (1 << 3))
  USB_EPTask[3]  = os_tsk_create(USB_EndPoint3,  2);
#endif
#if (USB_EP_EVENT & (1 << 4))
  USB_EPTask[4]  = os_tsk_create(USB_EndPoint4,  2);
#endif
#if (USB_EP_EVENT & (1 << 5))
  USB_EPTask[5]  = os_tsk_create(USB_EndPoint5,  2);
#endif
#if (USB_EP_EVENT & (1 << 6))
  USB_EPTask[6]  = os_tsk_create(USB_EndPoint6,  2);
#endif
#if (USB_EP_EVENT & (1 << 7))
  USB_EPTask[7]  = os_tsk_create(USB_EndPoint7,  2);
#endif
#if (USB_EP_EVENT & (1 << 8))
  USB_EPTask[8]  = os_tsk_create(USB_EndPoint8,  2);
#endif
#if (USB_EP_EVENT & (1 << 9))
  USB_EPTask[9]  = os_tsk_create(USB_EndPoint9,  2);
#endif
#if (USB_EP_EVENT & (1 << 10))
  USB_EPTask[10] = os_tsk_create(USB_EndPoint10, 2);
#endif
#if (USB_EP_EVENT & (1 << 11))
  USB_EPTask[11] = os_tsk_create(USB_EndPoint11, 2);
#endif
#if (USB_EP_EVENT & (1 << 12))
  USB_EPTask[12] = os_tsk_create(USB_EndPoint12, 2);
#endif
#if (USB_EP_EVENT & (1 << 13))
  USB_EPTask[13] = os_tsk_create(USB_EndPoint13, 2);
#endif
#if (USB_EP_EVENT & (1 << 14))
  USB_EPTask[14] = os_tsk_create(USB_EndPoint14, 2);
#endif
#if (USB_EP_EVENT & (1 << 15))
  USB_EPTask[15] = os_tsk_create(USB_EndPoint15, 2);
#endif

  USB_CoreTask = os_tsk_create(USB_Core, 2);
}
