/*----------------------------------------------------------------------------
 *      U S B  -  K e r n e l
 *----------------------------------------------------------------------------
 *      Name:    USBUSER.H
 *      Purpose: USB Custom User Definitions
 *      Version: V1.10
 *----------------------------------------------------------------------------
 *      This file is part of the uVision/ARM development tools.
 *      This software may only be used under the terms of a valid, current,
 *      end user licence from KEIL for a compatible version of KEIL software
 *      development tools. Nothing else gives you the right to use it.
 *
 *      Copyright (c) 2005-2007 Keil Software.
 *---------------------------------------------------------------------------*/

#ifndef __USBUSER_H__
#define __USBUSER_H__


/* USB Device Events */
#define USB_EVT_POWER_ON    0x0001  /* USB Power On */
#define USB_EVT_POWER_OFF   0x0002  /* USB Power Off */
#define USB_EVT_RESET       0x0004  /* USB Bus Reset */
#define USB_EVT_WAKEUP      0x0008  /* USB Remote Wakeup */
#define USB_EVT_SUSPEND     0x0010  /* USB Suspend */
#define USB_EVT_RESUME      0x0020  /* USB Resume */
#define USB_EVT_SOF         0x0040  /* USB Start of Frame */
#define USB_EVT_ERROR       0x0080  /* USB Error */

/* USB Endpoint Events */
#define USB_EVT_SETUP       0x0002  /* Setup Packet */
#define USB_EVT_OUT         0x0004  /* OUT Packet */
#define USB_EVT_IN          0x0008  /*  IN Packet */
#define USB_EVT_OUT_NAK     0x0010  /* OUT Packet - Not Acknowledged */
#define USB_EVT_IN_NAK      0x0020  /*  IN Packet - Not Acknowledged */
#define USB_EVT_OUT_STALL   0x0040  /* OUT Packet - Stalled */
#define USB_EVT_IN_STALL    0x0080  /*  IN Packet - Stalled */
#define USB_EVT_OUT_DMA_EOT 0x0100  /* DMA OUT EP - End of Transfer */
#define USB_EVT_IN_DMA_EOT  0x0200  /* DMA  IN EP - End of Transfer */
#define USB_EVT_OUT_DMA_NDR 0x0400  /* DMA OUT EP - New Descriptor Request */
#define USB_EVT_IN_DMA_NDR  0x0800  /* DMA  IN EP - New Descriptor Request */
#define USB_EVT_OUT_DMA_ERR 0x1000  /* DMA OUT EP - Error */
#define USB_EVT_IN_DMA_ERR  0x2000  /* DMA  IN EP - Error */

/* USB Core Events */
#define USB_EVT_SET_CFG     0x0001  /* Set Configuration */
#define USB_EVT_SET_IF      0x0002  /* Set Interface */
#define USB_EVT_SET_FEATURE 0x0004  /* Set Feature */
#define USB_EVT_CLR_FEATURE 0x0008  /* Clear Feature */


/* message structure */
typedef struct _T_USB_EP_EVENT {
  U16 wEvent;
  U8  bCnt;
  U8  bData[USB_CDC_BUFSIZE];	    /* see usbcfg.h  #define USB_CDC_BUFSIZE */
} T_USB_EP_EVENT;

extern U32 USB_MsgPool[];           /* dynamic memory pool used for messages*/

extern U32* USB_EPMbx[16];          /* USB Endpoint Mailboxes */

extern U32 USB_DevMbx[];            /* USB device  mailbox */
extern U32 USB_CoreMbx[];           /* USB device  mailbox */

/* USB Task IDs */
extern OS_TID USB_DevTask;          /* USB Device Task ID */
extern OS_TID USB_EPTask[16];       /* USB Endpoint Task ID's */
extern OS_TID USB_CoreTask;         /* USB Core Task ID */

/* USB User Functions */
extern void USB_TaskInit (void);    /* USB Task Initialization */


#endif  /* __USBUSER_H__ */
