//11-09

#include <windows.h>
#include "setupapi.h"
#include "hidsdi.h"
#include "hidpi.h"


//D'apres "USB COMPLETE"  Third edition Jan Axelson et de son programme "usbhidio"

//Recherche des peripheriques de type HID et affichage du "Report Descriptor"

	int VendorID=0xC251;
	int ProductID=0x1A01;  //Lakeview 
	DWORD MemberIndex,DeviceUsage;
	ULONG Length;
	HANDLE DeviceInfoSet;
	HANDLE DeviceHandle;
	
	GUID HidGuid;        /* GUID for HID driver */
	SP_DEVICE_INTERFACE_DATA MyDeviceInterfaceData;
	PHIDP_PREPARSED_DATA	PreparsedData;
	PSP_DEVICE_INTERFACE_DETAIL_DATA DetailData;

		
	HIDP_CAPS Capabilities;
	HIDD_ATTRIBUTES	Attributes;

	char MyDevicePathName[128];

	BOOLEAN Result;

	CHAR InputReportBuffer[3];
	DWORD BytesRead;
	DWORD Result2;
	HANDLE hEventObject;
	OVERLAPPED HIDOverlapped;

	
	void GetDeviceCapabilities(void)
{
	//Get the Capabilities structure for the device.


	/*
	API function: HidD_GetPreparsedData
	Returns: a pointer to a buffer containing the information about the device's capabilities.
	Requires: A handle returned by CreateFile.
	There's no need to access the buffer directly,
	but HidP_GetCaps and other API functions require a pointer to the buffer.
	*/
	

	HidD_GetPreparsedData 
		(DeviceHandle, 
		&PreparsedData);

	printf("HidD_GetPreparsedData: \n");

	/*
	API function: HidP_GetCaps
	Learn the device's capabilities.
	For standard devices such as joysticks, you can find out the specific
	capabilities of the device.
	For a custom device, the software will probably know what the device is capable of,
	and the call only verifies the information.
	Requires: the pointer to the buffer returned by HidD_GetPreparsedData.
	Returns: a Capabilities structure containing the information.
	*/
	

	HidP_GetCaps 
		(PreparsedData, 
		&Capabilities);
	printf("HidP_GetCaps: \n\n\n\n");

	printf("                      REPORT DESCRIPTOR \n");

	//Display the capabilities

	printf("Usage : %x\n ", Capabilities.Usage);

	printf("Usage Page: %x\n ", Capabilities.UsagePage);

	printf("Input Report Byte Length : %x\n ", Capabilities.InputReportByteLength);

	printf("Output Report Byte Length: %x \n  ", Capabilities.OutputReportByteLength);
	
	printf("Feature Report Byte Length: %x\n ", Capabilities.FeatureReportByteLength);

	printf("Reserved: %x\n ", Capabilities.Reserved);
	
	printf("Number of Link Collection Nodes:%x \n ", Capabilities.NumberLinkCollectionNodes);

	printf("Number of Input Button Caps: %x\n ", Capabilities.NumberInputButtonCaps);

	printf("Number of InputValue Caps:%x\n  ", Capabilities.NumberInputValueCaps);
	
	printf("Number of InputData Indices:%x \n ", Capabilities.NumberInputDataIndices);
	
	printf("Number of Output Button Caps: %x\n ", Capabilities.NumberOutputButtonCaps);

	printf("Number of Output Value Caps: %x\n  ", Capabilities.NumberOutputValueCaps);
	
	printf("Number of Output Data Indices: %x\n  ", Capabilities.NumberOutputDataIndices);
	
	printf("Number of Feature Button Caps: %x\n  ", Capabilities.NumberFeatureButtonCaps);
	
	printf("Number of Feature Value Caps: %x\n ", Capabilities.NumberFeatureValueCaps);
	
	printf("Number of Feature Data Indices: %x\n\n\n\n ", Capabilities.NumberFeatureDataIndices);

	// Find out if the device is a system mouse or keyboard.
					
	DeviceUsage = (Capabilities.UsagePage * 256) + Capabilities.Usage;

		if (DeviceUsage == 0x102)
				printf( "peripherique type mouse \n");
				
		if (DeviceUsage == 0x106)
				printf("peripherique type keyboard \n");
		HidD_FreePreparsedData(PreparsedData);

};


	


void main(void)
{
	
		HidD_GetHidGuid(&HidGuid); 
//device_test
 
DeviceInfoSet=SetupDiGetClassDevs 
		(&HidGuid, 
		NULL, 
		NULL, 
		DIGCF_PRESENT|DIGCF_INTERFACEDEVICE);
	


for(MemberIndex=0;(MemberIndex<4);MemberIndex++)
	{
//enumeration


MyDeviceInterfaceData.cbSize=sizeof(MyDeviceInterfaceData);
//MemberIndex=0;
Result=SetupDiEnumDeviceInterfaces
(DeviceInfoSet,
 0,
 &HidGuid,
 MemberIndex,
 &MyDeviceInterfaceData);

if (Result) printf("Peripherique indice %d present   \n",MemberIndex);
else break;
 printf("taille %d\n",sizeof(MyDeviceInterfaceData));
  


			Result = SetupDiGetDeviceInterfaceDetail 
				(DeviceInfoSet, 
				&MyDeviceInterfaceData, 
				NULL, 
				0, 
				&Length, 
				NULL);

			//Allocate memory for the hDevInfo structure, using the returned Length.

			DetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)malloc(Length);
			
			//Set cbSize in the detailData structure.

			DetailData -> cbSize = sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
		//  printf("taille %d\n",sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA));

			//Call the function again, this time passing it the returned buffer size.

				Result = SetupDiGetDeviceInterfaceDetail 
				(DeviceInfoSet, 
				&MyDeviceInterfaceData, 
				DetailData,
				Length, 
				&Length, 
				NULL);

				printf ("path  %s \n",DetailData->DevicePath);
			
//recherche_handle

			DeviceHandle=CreateFile 
				(DetailData->DevicePath, 
				0, 
				FILE_SHARE_READ|FILE_SHARE_WRITE, 
				(LPSECURITY_ATTRIBUTES)NULL,
				OPEN_EXISTING, 
				0, 
				NULL);
if (DeviceHandle==INVALID_HANDLE_VALUE) printf("Erreur de handle %d \n", GetLastError());

//Recherche_infos

/*Returns: a HIDD_ATTRIBUTES structure containing
the Vendor ID, Product ID, and Product Version Number.*/
				

			Attributes.Size = sizeof(Attributes);

			Result = HidD_GetAttributes 
				(DeviceHandle, 
				&Attributes);	
			//Is it the desired device?

			printf("VID %4.4x \n",Attributes.VendorID );
			printf("PID %4.4x \n",Attributes.ProductID );
			//printf("boucles");
			if (Attributes.VendorID == VendorID)
			{
				if (Attributes.ProductID == ProductID)
				{
					//Both the Vendor ID and Product ID match.
					GetDeviceCapabilities();
					hEventObject = CreateEvent((LPSECURITY_ATTRIBUTES)NULL,FALSE,TRUE," ");

					HIDOverlapped.hEvent = hEventObject;
					HIDOverlapped.Offset = 0;
					HIDOverlapped.OffsetHigh = 0;

					InputReportBuffer[0] = 0;

					DeviceHandle = CreateFile(DetailData->DevicePath,GENERIC_READ|GENERIC_WRITE, FILE_SHARE_READ|FILE_SHARE_WRITE, (LPSECURITY_ATTRIBUTES)NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);

					Result2 = ReadFile(DeviceHandle, InputReportBuffer, Capabilities.InputReportByteLength, &BytesRead, (LPOVERLAPPED) &HIDOverlapped);

					Result2 = WaitForSingleObject(hEventObject,3000);
					printf("Result : %d\n",Result2);
					switch(Result2){
						case WAIT_OBJECT_0 :
							printf("Read Successfull : %s\n",InputReportBuffer);
							break;
						
						case WAIT_TIMEOUT :
							CancelIo(DeviceHandle);
							printf("Timeout Error\n");
							break;

						default :
							printf("Error\n");
							CancelIo(DeviceHandle);
							break;
					}
					
					// MyDevicePathName = DetailData->DevicePath;
						printf("Device detected\n");	
				}else printf("Device not detected\n");	
			}
		
			//GetDeviceCapabilities();

			CloseHandle(DeviceHandle);  //enlever test un periph
		
		}

		getchar();

}  //fin de main
