#include <stdio.h>
#include "usb.h"
#include <string.h>

extern int verbose;

int main(int argc, char *argv[])
{
	struct usb_bus *bus;
	struct usb_device *dev;
	usb_dev_handle *udev;
	char receive_data[1];
	char i;

	int etat;

	usb_init();

	usb_find_busses();
	usb_find_devices();

	for (bus = usb_get_busses(); bus; bus = bus->next) {
		if (!(bus->root_dev && !verbose)){

			for (dev = bus->devices; dev; dev = dev->next)
			{	
				if(dev->descriptor.idVendor==0x547 && dev->descriptor.idProduct==0x1002)
				{
					udev = usb_open(dev);
					etat = usb_set_configuration(udev,1);
					printf("Config : %d\n",etat);
					etat = usb_claim_interface(udev,0);
					printf("Claim interface : %d\n",etat);
					etat = usb_set_altinterface(udev,0);
					printf("Claim altinterface : %d\n",etat);
					for(i=1;i!=255;i++){
						etat = usb_bulk_write(udev,2,&i,1,500);
						printf("Ecriture : %d\n",etat);
						_sleep(400);
						etat = usb_bulk_read(udev,134,receive_data,1,500);
						printf("Lecture : %d\n",etat);
					}

					usb_close(udev);
					usb_release_interface(udev,0);
					usb_reset(udev);
				}
			}
		}
	}

	return 0;
}