// UsbSample.cpp : Defines the entry point for the console application.
//

#include <stdio.h>
#include "usb.h"
#include <string.h>

int verbose = 1;

void print_endpoint(struct usb_endpoint_descriptor *endpoint)
{
   printf("    Ad_EndPoint   %d\n", endpoint->bEndpointAddress);
}

void print_altsetting(struct usb_interface_descriptor *interface)
{
	printf("    Interface_Num   %d\nClasse : %d\n", interface->bInterfaceNumber,interface->bInterfaceClass);

  for (int i = 0; i < interface->bNumEndpoints; i++)
    print_endpoint(&interface->endpoint[i]);
}

void print_interface(struct usb_interface *interface)
{

  for (int i = 0; i < interface->num_altsetting; i++)
    print_altsetting(&interface->altsetting[i]);
}

void print_configuration(struct usb_config_descriptor *config)
{

	printf("  Length_config    :         %d\n", config->wTotalLength);
  for (int i = 0; i < config->bNumInterfaces; i++)
    print_interface(&config->interface[i]);
}

int print_device(struct usb_device *dev, int level)
{
  usb_dev_handle *udev;
  char description[256];
  char string[256];
  int ret, i;

  udev = usb_open(dev);

  printf("\nDevice : 0x0%x - 0x0%x\n", dev->descriptor.idVendor, dev->descriptor.idProduct);

  if (udev) {
    if (dev->descriptor.iManufacturer) {
      ret = usb_get_string_simple(udev, dev->descriptor.iManufacturer, string, sizeof(string));
      if (ret > 0)
        sprintf(description, "%s - ", string);
      else
        sprintf(description, "%04X - ",
                 dev->descriptor.idVendor);
    } else
      sprintf(description, "%04X - ",
               dev->descriptor.idVendor);

    if (dev->descriptor.iProduct) {
      ret = usb_get_string_simple(udev, dev->descriptor.iProduct, string, sizeof(string));
      if (ret > 0)
        sprintf(description + strlen(description), "%s", string);
      else
        sprintf(description + strlen(description), "%04X", dev->descriptor.idProduct);
    } else
      sprintf(description + strlen(description), "%04X", dev->descriptor.idProduct);

  } else
    sprintf(description, "%04X - %04X",
             dev->descriptor.idVendor, dev->descriptor.idProduct);

  printf("%.*sDev #%d: %s\n", level * 2, "                    ", dev->devnum,
	  description);

  if (udev && verbose) {
    if (dev->descriptor.iSerialNumber) {
      ret = usb_get_string_simple(udev, dev->descriptor.iSerialNumber, string, sizeof(string));
      if (ret > 0)
        printf("%.*s  - Serial Number: %s\n", level * 2,
               "                    ", string);
    }
  }

  if (udev)
    usb_close(udev);

  if (verbose) {
    if (!dev->config) {
      printf("  Couldn't retrieve descriptors\n");
      return 0;
    }

    for (i = 0; i < dev->descriptor.bNumConfigurations; i++)
      print_configuration(&dev->config[i]);
  } else {
    for (i = 0; i < dev->num_children; i++)
      print_device(dev->children[i], level + 1);
  }

  return 0;
}


int main2(int argc, char *argv[])
{
  struct usb_bus *bus;

  usb_init();

  usb_find_busses();
  usb_find_devices();

  for (bus = usb_get_busses(); bus; bus = bus->next) {
    if (bus->root_dev && !verbose) 
	print_device(bus->root_dev, 0);
    else {
      struct usb_device *dev;

	  for (dev = bus->devices; dev; dev = dev->next)
		 print_device(dev, 0);
    }
  }

  	/* open_status = usb_set_configuration(xsv_handle,1); */
	
	/* open_status = usb_claim_interface(xsv_handle,0); */
	
	/* open_status = usb_set_altinterface(xsv_handle,0); */

	/* send_status=usb_bulk_write(xsv_handle,4,&send_data,1,500); */
	
	/* usb_bulk_read(xsv_handle,3,&receive_data,1,500);	 */

  return 0;
}
